/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.ui;

import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.managed.TaskProperties;
import com.ibm.hwmca.fw.ui.UIHwmcaObject;
import com.ibm.hwmca.fw.ui.UIInfo;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class UITask
extends UIHwmcaObject
implements TaskProperties {
    private HashSet permittedObjects;
    private String presentationTaskClassName;
    private boolean anyPermitted = false;
    private boolean targetRequired = true;
    private transient Object permittedObjectsLock;

    public UITask(ObjectId objectId, UIInfo uiInfo, String className, Set permittedObjects, boolean anyPermitted, boolean targetRequired) {
        super(objectId, uiInfo);
        this.presentationTaskClassName = className;
        this.permittedObjects = new HashSet(permittedObjects);
        this.anyPermitted = anyPermitted;
        this.targetRequired = targetRequired;
    }

    public Set getPermittedObjects() {
        return this.permittedObjects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isObjectPermitted(ObjectId objectId) {
        boolean result = false;
        if (this.anyPermitted) {
            result = true;
        } else {
            String className = objectId.getFullClassName();
            if (this.permittedObjectsLock == null) {
                this.permittedObjectsLock = new Object();
            }
            Object object = this.permittedObjectsLock;
            synchronized (object) {
                Iterator iterator = this.permittedObjects.iterator();
                while (iterator.hasNext() && !result) {
                    String name = (String)iterator.next();
                    if (!className.equals(name)) continue;
                    result = true;
                }
            }
        }
        return result;
    }

    public String getPresentationTaskClassName() {
        return this.presentationTaskClassName;
    }

    public boolean isAnyPermitted() {
        return this.anyPermitted;
    }

    public boolean isTargetRequired() {
        return this.targetRequired;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPermittedObjects(Set permittedObjects) {
        if (this.permittedObjectsLock == null) {
            this.permittedObjectsLock = new Object();
        }
        HashSet oldValue = null;
        Object object = this.permittedObjectsLock;
        synchronized (object) {
            oldValue = (HashSet)this.permittedObjects.clone();
            this.permittedObjects.clear();
            this.permittedObjects.addAll(permittedObjects);
        }
        if (this.propertyChangeSupport != null) {
            this.propertyChangeSupport.firePropertyChange("PermittedObjects", oldValue, permittedObjects);
        }
    }
}

